Attribute VB_Name = "Functions"
Option Explicit
Public Const PI = 3.14159
Public Const SWP_NOMOVE = 2
Public Const SWP_NOSIZE = 1
Public Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Public Const HWND_TOPMOST = -1
Public Const HWND_NOTOPMOST = -2

Declare Function SetWindowPos Lib "user32" _
      (ByVal hwnd As Long, _
      ByVal hWndInsertAfter As Long, _
      ByVal X As Long, _
      ByVal Y As Long, _
      ByVal cx As Long, _
      ByVal cy As Long, _
      ByVal wFlags As Long) As Long
Declare Sub Sleep Lib "KERNEL32" (ByVal dwMilliseconds As Long)
Declare Function GetTickCount Lib "KERNEL32" () As Long
Declare Sub GetSystemTimeAdjustment Lib "KERNEL32" (ByRef timeAdjustment As Long, ByRef timeIncrement As Long, ByRef timeAdjustmentDisabled As Long)

Public minSlice As Integer
Public ExitSpiral As Boolean


Public Function SetTopMostWindow(hwnd As Long, Topmost As Boolean) _
   As Long

   If Topmost = True Then 'Make the window topmost
      SetTopMostWindow = SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, _
         0, FLAGS)
   Else
      SetTopMostWindow = SetWindowPos(hwnd, HWND_NOTOPMOST, 0, 0, _
         0, 0, FLAGS)
      SetTopMostWindow = False
   End If
End Function
Public Sub InitProg()
On Error GoTo NSError
   Dim timeAdjustment As Long
   Dim timeIncrement As Long
   Dim timeAdjustmentDisabled As Long
   
   GetSystemTimeAdjustment timeAdjustment, timeIncrement, timeAdjustmentDisabled
   minSlice = CDbl(timeIncrement) / 10000# + 1
Exit Sub
NSError:
  MsgBox Err.Description & " - " & Err.Number
End Sub
Public Function ScopeComm(strCommand As String, NumCharReturned As Integer, MilliSecondsToWait As Integer) As String
On Error GoTo NSError
    Dim strScopeResponse As String
    Dim strClear As String
    Dim StartTime As Long
    
    strScopeResponse = ""
    Interface!Comm1.PortOpen = True
    Interface!Comm1.InputLen = 1000
    strClear = Interface!Comm1.Input
    Interface!Comm1.InputLen = 1
    Interface!Comm1.Output = strCommand
    StartTime = GetTickCount
    
    Do While Len(strScopeResponse) < NumCharReturned And GetTickCount - StartTime < MilliSecondsToWait
        strScopeResponse = strScopeResponse & Interface!Comm1.Input
'        DoEvents
        Sleep minSlice
    Loop
    
    Interface!Comm1.PortOpen = False
    
    ScopeComm = strScopeResponse
    

Exit Function
NSError:
  MsgBox Err.Description & " - " & Err.Number
  ExitSpiral = True
  If Interface!Comm1.PortOpen = True Then
    Interface!Comm1.PortOpen = False
  End If
End Function

Public Sub Spiral()
On Error GoTo NSError
    Dim Cntr As Integer
    Dim strScopeResponse As String
    Dim StartTime As Long
    Dim LegInterval As Long
    Dim IntervalStep As Long
    Dim TrackRateAzHigh As Integer
    Dim TrackRateAzLow As Integer
    Dim TrackRateAltHigh As Integer
    Dim TrackRateAltLow As Integer
    Dim TrackRateAltRaw As Integer
    Dim TrackRateAzRaw As Integer
    Dim TrackRateBase As Integer
    Dim strCoord As String
    Dim Dec1 As Double
    Dim Dec2 As Double
    Dim Dec As Double
    Dim CornerDelay As Long
    Dim CornerDelayStartTime As Long
    
    Interface!lblSpiral.Visible = True
    TrackRateBase = 500
    TrackRateAltRaw = TrackRateBase * Val(Interface!txtWidth)
    
    TrackRateAltHigh = Int(TrackRateAltRaw / 256)
    TrackRateAltLow = TrackRateAltRaw Mod 256
    
    strCoord = "Z"
    strScopeResponse = ScopeComm(strCoord, 10, 500)
    Dec1 = Val("&h" & (Mid(strScopeResponse, 6, 2)))
    Dec2 = Val("&h" & (Mid(strScopeResponse, 8, 2)))
    Dec = (((Dec1 * 256) + Dec2) * 360 / 65536)
    If Dec > 95 Then Dec = 360 - Dec
    
    TrackRateAzRaw = (Tan(((Dec - 0.1) * PI) / 180) + 1) * TrackRateAltRaw
    If TrackRateAzRaw > 43200 Then TrackRateAzRaw = 43200
    TrackRateAzHigh = Int(TrackRateAzRaw / 256)
    TrackRateAzLow = TrackRateAzRaw Mod 256
    
    IntervalStep = 500  'This is milliseconds to run at given tracking rates
    LegInterval = 0
    Cntr = 0
    ExitSpiral = False
    CornerDelay = Val(Interface!txtCornerDelay) * 1000
    StartTime = GetTickCount
    Do While Not ExitSpiral
        If GetTickCount - StartTime > LegInterval Then
            If Cntr > 0 And CornerDelay > 0 Then
                strCoord = Chr(80) & Chr(2) & Chr(17) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strCoord = Chr(80) & Chr(2) & Chr(16) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strScopeResponse = ScopeComm("T" & Chr(Interface!cmbTrackMode.ItemData(Interface!cmbTrackMode.ListIndex)), 1, 500)
                CornerDelayStartTime = GetTickCount
                Do While Not ExitSpiral And (GetTickCount - CornerDelayStartTime < CornerDelay)
                    DoEvents
                    Sleep minSlice
                Loop
            End If
                    
            strScopeResponse = ScopeComm("T" & Chr(0), 1, 500)
            StartTime = GetTickCount
            If Cntr Mod 2 = 0 Then
                LegInterval = LegInterval + IntervalStep
            End If
            If Cntr Mod 4 = 0 Then
            '   slew Right
                strCoord = Chr(80) & Chr(2) & Chr(17) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strCoord = Chr(80) & Chr(3) & Chr(16) & Chr(6) & Chr(TrackRateAzHigh) & Chr(TrackRateAzLow) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
            Else
            If Cntr Mod 4 = 1 Then
            '   slew up
                strCoord = Chr(80) & Chr(2) & Chr(16) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strCoord = Chr(80) & Chr(3) & Chr(17) & Chr(7) & Chr(TrackRateAltHigh) & Chr(TrackRateAltLow) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
            Else
            If Cntr Mod 4 = 2 Then
            '   slew Left
                strCoord = Chr(80) & Chr(2) & Chr(17) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strCoord = Chr(80) & Chr(3) & Chr(16) & Chr(7) & Chr(TrackRateAzHigh) & Chr(TrackRateAzLow) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
            Else
            If Cntr Mod 4 = 3 Then
            '   slew down
                strCoord = Chr(80) & Chr(2) & Chr(16) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
                strCoord = Chr(80) & Chr(3) & Chr(17) & Chr(6) & Chr(TrackRateAltHigh) & Chr(TrackRateAltLow) & Chr(0) & Chr(0)
                strScopeResponse = ScopeComm(strCoord, 1, 500)
            End If
            End If
            End If
            End If
            Cntr = Cntr + 1
        End If
        DoEvents
        Sleep minSlice
    Loop
    
    strCoord = Chr(80) & Chr(2) & Chr(17) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
    strScopeResponse = ScopeComm(strCoord, 1, 500)
    strCoord = Chr(80) & Chr(2) & Chr(16) & Chr(37) & Chr(0) & Chr(0) & Chr(0) & Chr(0)
    strScopeResponse = ScopeComm(strCoord, 1, 500)
    strScopeResponse = ScopeComm("T" & Chr(Interface!cmbTrackMode.ItemData(Interface!cmbTrackMode.ListIndex)), 1, 500)
    Interface!lblSpiral.Visible = False
    
    

Exit Sub
NSError:
  MsgBox Err.Description & " - " & Err.Number

End Sub

